/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef RF_SYSTEM_MINIMAL_H
#define RF_SYSTEM_MINIMAL_H
#include "rf_system.h"
#include "rcm_class.h"
#include <QThread>

#define CHANNELCOUNT 1

class RF_System_Minimal : public QObject
{
	Q_OBJECT

public:
	RF_System_Minimal();
	~RF_System_Minimal();

	QList<QThread*> *threadList;

	RCM_Class *RCM_USB_port;
	ConfigHandler *config;

	int channelCount();

private:
//	void firmware_version_check();
//	int	firmware_version_actual[4];
//	int	firmware_version_requirement[4];

	QThread *channelThread;
	RF_Channel *channel;
	int channel_count = CHANNELCOUNT;

public slots:
	void RCM_USB_message_handler();
	void RCM_USB_response_handler(QString response);
	void RCM_USB_message_handler_blind();
	void RCM_USB_response_handler_blind(QString response);
	void RCM_USB_error_handler(QSerialPort::SerialPortError error);

signals:
	void signal_RCM_USB_message(QString message);
	void signal_RCM_sweep_message(QString message);
};

#endif //RF_SYSTEM_MINIMAL_H
